///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

/*=======================================================================
** Updaded by Pascal Estrade (Sep 2014)
**=======================================================================*/
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <VolumeViz/nodes/SoVolumeData.h>

#include <Medical/InventorMedical.h>
#include <Medical/helpers/MedicalHelper.h>

///////////////////////////////////////////////////////////////////////////////
//main function
int main(int /*argc*/, char **argv)
{
    Widget myWindow = SoXt::init(argv[0]);
    if (!myWindow)
        return 0;

    SoVolumeRendering::init();
    InventorMedical::init();

    SbString filename = "$OIVHOME/examples/source/Medical/Rendering/Multiple Volumes/medicalVolumeTextureCompose/VolumeTextureCompose.iv";

    SoSeparator* scene = MedicalHelper::readFile(filename.toLatin1());
    if(!scene)
        return 0;

    SoRef<SoSeparator> root = new SoSeparator;

    root->addChild(scene);

    SoVolumeData *ivFileVolumeData = MedicalHelper::find<SoVolumeData>(root.ptr());
    root->addChild( MedicalHelper::createBoundingBox( ivFileVolumeData->extent.getValue() ) );

    // OIV Logo
    root->addChild( MedicalHelper::exampleLogoNode() );

    // Set up viewer:
    SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
    myViewer->setTransparencyType(SoGLRenderAction::NO_SORT);
    myViewer->setSceneGraph(root.ptr());
    myViewer->setTitle("Volume & Texture composition");
    myViewer->setDecoration(false);
    myViewer->setSize( MedicalHelper::exampleWindowSize() );
    myViewer->viewAll();
    myViewer->show();

    SoXt::show(myWindow);
    SoXt::mainLoop();
    delete myViewer;

    root = NULL;
    InventorMedical::finish();
    SoVolumeRendering::finish();
    SoXt::finish();
    return 0;
}


